/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.client.IHudSkillRenderer;
import dev.toma.gunsrpg.api.common.IAmmoProvider;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IDebuffs;
import dev.toma.gunsrpg.api.common.data.IKillData;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.IProgressData;
import dev.toma.gunsrpg.api.common.data.IQuests;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.api.common.skill.ICooldown;
import dev.toma.gunsrpg.api.common.skill.ISkill;
import dev.toma.gunsrpg.client.render.debuff.DebuffRenderManager;
import dev.toma.gunsrpg.client.render.infobar.IDataModel;
import dev.toma.gunsrpg.client.render.skill.SkillRendererRegistry;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.item.StashDetectorItem;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.setup.AbstractGun;
import dev.toma.gunsrpg.common.quests.quest.QuestStatus;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.config.client.QuestOverlayConfig;
import dev.toma.gunsrpg.resource.util.functions.RangedFunction;
import dev.toma.gunsrpg.sided.ClientSideManager;
import dev.toma.gunsrpg.util.Lifecycle;
import dev.toma.gunsrpg.util.RenderUtils;
import dev.toma.gunsrpg.util.SkillUtil;
import dev.toma.gunsrpg.util.locate.ammo.ItemLocator;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class HUDRenderer {
    @SubscribeEvent
    public void cancelOverlays(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            ItemStack stack;
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            if (!ClientSideManager.config.developerMode && (stack = player.func_184614_ca()).func_77973_b() instanceof AbstractGun) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void renderOverlays(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null) {
            return;
        }
        ClientPlayerEntity player = mc.field_71439_g;
        LazyOptional<IPlayerData> optional = PlayerData.get((PlayerEntity)player);
        MatrixStack matrixStack = event.getMatrixStack();
        MainWindow window = event.getWindow();
        FontRenderer font = mc.field_71466_p;
        float partialTicks = event.getPartialTicks();
        optional.ifPresent(arg_0 -> this.lambda$renderOverlays$0(matrixStack, font, window, (PlayerEntity)player, partialTicks, arg_0));
    }

    private void renderQuestOverlay(MatrixStack matrix, FontRenderer font, MainWindow window, IPlayerData data) {
        IQuests quests = data.getQuests();
        quests.getActiveQuest().ifPresent(quest -> {
            QuestStatus status = quest.getStatus();
            if (status != QuestStatus.ACTIVE && status != QuestStatus.COMPLETED) {
                return;
            }
            LazyOptional<IDataModel> modelOptional = quest.getDisplayModel();
            modelOptional.ifPresent(model -> {
                QuestOverlayConfig config = ClientSideManager.config.questOverlay;
                boolean rightAlignment = config.rightAligned;
                int posX = rightAlignment ? window.func_198107_o() : 0;
                model.renderModel(matrix, font, posX, config.heightOffset, rightAlignment);
            });
        });
    }

    private <S extends ISkill & ICooldown> void renderSkillsOnHUD(MatrixStack stack, MainWindow window, IPlayerData data) {
        ISkillProvider provider = data.getSkillProvider();
        Set displayables = SkillRendererRegistry.getDisplayableSkills().stream().map(type -> SkillUtil.getTopHierarchySkill(type, provider)).filter(skill -> skill != null && !skill.getType().isDisabled()).collect(Collectors.toSet());
        int renderIndex = 0;
        for (ISkill skill2 : displayables) {
            if (((ICooldown)((Object)skill2)).getCooldown() > 0) continue;
            SkillType<?> type2 = skill2.getType();
            IHudSkillRenderer<?> renderer = SkillRendererRegistry.getHudRenderer(type2);
            renderer.renderOnHUD(stack, skill2, 5, window.func_198087_p() - 20, renderIndex++);
        }
    }

    private void renderBloodmoonInfo(MatrixStack matrixStack, FontRenderer font, MainWindow window, PlayerEntity player) {
        int color;
        World world = player.field_70170_p;
        long actualDay = world.func_72820_D() / 24000L;
        int cycle = GunsRPG.config.world.bloodmoonCycle;
        if (cycle == -1 || !ClientSideManager.config.showBloodmoonRemainingDays) {
            return;
        }
        boolean isBloodmoonDay = actualDay > 0L && (cycle == 0 || actualDay % (long)cycle == 0L);
        int leftToBloodmoon = isBloodmoonDay ? 0 : (int)((long)cycle - actualDay % (long)cycle);
        boolean isNight = world.func_72820_D() % 24000L >= 12500L;
        String dayString = isNight && isBloodmoonDay ? leftToBloodmoon + "!" : String.valueOf(leftToBloodmoon);
        int dayStringWidth = font.func_78256_a(dayString);
        int xPos = window.func_198107_o() - 9;
        boolean shouldRenderBackground = this.hasActiveVisibleEffect((LivingEntity)player);
        int n = isBloodmoonDay ? 0xFF0000 : (color = RangedFunction.BETWEEN_EXCLUSIVE.isWithinRange(leftToBloodmoon, 0, 3) ? 0xFFFF00 : 0xFFFFFF);
        if (shouldRenderBackground) {
            Matrix4f pose = matrixStack.func_227866_c_().func_227870_a_();
            this.renderBloodmoonWarningBackground(pose, xPos, dayStringWidth, color);
        }
        font.func_238405_a_(matrixStack, dayString, 0.5f + (float)xPos - (float)dayStringWidth / 2.0f, 6.0f, color);
    }

    private void renderBloodmoonWarningBackground(Matrix4f pose, int x, int textWidth, int color) {
        float left = (float)x - (float)textWidth / 2.0f;
        float right = left + (float)textWidth;
        RenderUtils.drawSolid(pose, left - 3.0f, 3.0f, right + 3.0f, 16.0f, 0xFF000000 | color);
        RenderUtils.drawSolid(pose, left - 2.0f, 4.0f, right + 2.0f, 15.0f, -16777216);
    }

    private boolean hasActiveVisibleEffect(LivingEntity entity) {
        for (EffectInstance instance : entity.func_70651_bq()) {
            if (!instance.func_188418_e()) continue;
            return true;
        }
        return false;
    }

    private void renderDebuffs(MatrixStack poseStack, IAttributeProvider attributeProvider, IDebuffs debuffs, int left, int top, float partialTicks) {
        ClientSideManager manager = ClientSideManager.instance();
        DebuffRenderManager renderManager = manager.getDebuffRenderManager();
        renderManager.drawDebuffsOnScreen(poseStack, attributeProvider, debuffs, left, top, partialTicks);
    }

    private void renderProgressionOnScreen(MatrixStack matrix, FontRenderer font, MainWindow window, IPlayerData data, PlayerEntity player) {
        int windowWidth = window.func_198107_o();
        int windowHeight = window.func_198087_p();
        int barWidth = 26;
        int x = windowWidth - barWidth - 34;
        int y = windowHeight - 22;
        ItemStack stack = player.func_184614_ca();
        Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
        IProgressData progression = data.getProgressData();
        if (stack.func_77973_b() instanceof GunItem) {
            GunItem gunItem = (GunItem)stack.func_77973_b();
            IKillData killData = progression.getWeaponStats(gunItem);
            Lifecycle lifecycle = GunsRPG.getModLifecycle();
            IAmmoProvider provider = lifecycle.getAmmoForWeapon(gunItem, stack);
            if (provider != null) {
                boolean jammed = gunItem.isJammed(stack);
                boolean broken = stack.func_77952_i() == stack.func_77958_k();
                String text = this.getAmmoString(gunItem, stack, (IInventory)player.field_71071_by, provider, jammed, broken);
                barWidth = font.func_78256_a(text);
                x = windowWidth - barWidth - 34;
                this.renderProgressionBar(killData, matrix, font, x, y, barWidth + 22, y + 7, -256, -7829504);
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_175599_af().func_175042_a(new ItemStack((IItemProvider)((Item)provider)), x, y - 18);
                if (jammed || broken) {
                    font.func_238405_a_(matrix, text, (float)(x + 19), (float)(y - 14), 0xCC0000);
                } else {
                    font.func_238421_b_(matrix, text, (float)(x + 19), (float)(y - 14), 0xFFFFFF);
                }
            }
        } else if (stack.func_77973_b() == ModItems.STASH_DETECTOR) {
            Minecraft mc = Minecraft.func_71410_x();
            int batteryCount = ItemLocator.sum((IInventory)player.field_71071_by, StashDetectorItem::isValidBatterySource);
            String text = String.valueOf(batteryCount);
            barWidth = font.func_78256_a(text);
            x = windowWidth - barWidth - 34;
            mc.func_175599_af().func_175042_a(new ItemStack((IItemProvider)ModItems.BATTERY), x, y - 8);
            font.func_238421_b_(matrix, text, (float)(x + 19), (float)(y - 2), 0xFFFFFF);
        }
        this.renderProgressionBar(progression, matrix, font, x, y + 10, barWidth + 22, y + 17, -16711681, -16742264);
    }

    private String getAmmoString(GunItem item, ItemStack stack, IInventory inventory, IAmmoProvider provider, boolean jammed, boolean broken) {
        int loaded = item.getAmmo(stack);
        return jammed ? "\u5361\u5f39" : (broken ? "\u5df2\u635f\u574f" : loaded + " / " + ItemLocator.sum(inventory, ItemLocator.filterByAmmoTypeAndMaterial(provider)));
    }

    private void renderProgressionBar(IKillData data, MatrixStack matrixStack, FontRenderer font, int left, int top, int width, int bottom, int colorPrimary, int colorSecondary) {
        Matrix4f pose = matrixStack.func_227866_c_().func_227870_a_();
        int count = data.getKills();
        int required = data.getRequiredKillCount();
        int level = data.getLevel();
        boolean isMaxLvl = level == data.getLevelLimit();
        float levelProgress = isMaxLvl ? 1.0f : (float)count / (float)required;
        RenderUtils.drawSolid(pose, left, top, left + width, bottom, -16777216);
        RenderUtils.drawGradient(pose, left + 2, top + 2, left + (int)(levelProgress * (float)(width - 2)), bottom - 2, colorPrimary, colorSecondary);
        String currentLevel = String.valueOf(level);
        int currentLevelWidth = font.func_78256_a(currentLevel);
        font.func_238421_b_(matrixStack, currentLevel, (float)(left - currentLevelWidth - 2), (float)top, colorPrimary);
    }

    private /* synthetic */ void lambda$renderOverlays$0(MatrixStack matrixStack, FontRenderer font, MainWindow window, PlayerEntity player, float partialTicks, IPlayerData data) {
        IAttributeProvider attributeProvider = data.getAttributes();
        IDebuffs debuffs = data.getDebuffControl();
        this.renderBloodmoonInfo(matrixStack, font, window, player);
        int height = window.func_198087_p();
        this.renderDebuffs(matrixStack, attributeProvider, debuffs, 0, height - 50, partialTicks);
        this.renderProgressionOnScreen(matrixStack, font, window, data, player);
        this.renderSkillsOnHUD(matrixStack, window, data);
        this.renderQuestOverlay(matrixStack, font, window, data);
    }
}

